/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.Base64;

public class CredentialsInterceptor
extends BaseInterceptor {
    int userNote;
    int passwordNote;
    public static final String USER_NOTE = "credentials.user";
    public static final String PASSWORD_NOTE = "credentials.password";

    public void engineInit(ContextManager cm) throws TomcatException {
        this.userNote = cm.getNoteId(2, USER_NOTE);
        this.passwordNote = cm.getNoteId(2, PASSWORD_NOTE);
    }

    public int authenticate(Request req, Response res) {
        Context ctx = req.getContext();
        String login_type = ctx.getAuthMethod();
        if ("BASIC".equals(login_type)) {
            this.basicCredentials(req);
        }
        if ("FORM".equals(login_type)) {
            this.formCredentials(req);
        }
        return -1;
    }

    private void basicCredentials(Request req) {
        String authorization = req.getHeader("Authorization");
        if (authorization == null) {
            return;
        }
        if (!authorization.startsWith("Basic ")) {
            this.log("Wrong syntax for basic authentication " + req + " " + authorization);
            return;
        }
        String unencoded = Base64.base64Decode((String)(authorization = authorization.substring(6).trim()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            this.log("Wrong syntax for basic authentication " + req + " " + authorization);
            return;
        }
        req.setNote(this.userNote, (Object)unencoded.substring(0, colon));
        req.setNote(this.passwordNote, (Object)unencoded.substring(colon + 1));
    }

    private void formCredentials(Request req) {
        ServerSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        String username = (String)session.getAttribute("j_username");
        String password = (String)session.getAttribute("j_password");
        if (username != null && password != null) {
            req.setNote(this.userNote, (Object)username);
            req.setNote(this.passwordNote, (Object)password);
        }
    }
}

