/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseException;
import org.apache.tomcat.util.log.Log;

public class JspReader {
    protected Mark current = null;
    String master = null;
    Vector sourceFiles = new Vector();
    int currFileId = 0;
    int size = 0;
    private JspCompilationContext context;
    Log loghelper = Log.getLog((String)"JASPER_LOG", (String)"JspReader");
    private String encoding = null;

    public String getFile(int fileid) {
        return (String)this.sourceFiles.elementAt(fileid);
    }

    protected int registerSourceFile(String file) {
        if (this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.addElement(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected int unregisterSourceFile(String file) {
        if (!this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.removeElement(file);
        --this.size;
        return this.sourceFiles.size() - 1;
    }

    public void pushFile(String name) throws ParseException, FileNotFoundException {
        this.pushFile(name, this.encoding);
    }

    public void pushFile(String name, String encoding) throws ParseException, FileNotFoundException {
        String parent = this.master == null ? null : this.master.substring(0, this.master.lastIndexOf("/") + 1);
        boolean isAbsolute = name.startsWith("/");
        if (parent == null || isAbsolute) {
            this.master = name;
            this.pushFile(new File(name), encoding);
        } else {
            this.master = parent + name;
            this.pushFile(new File(this.master), encoding);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushFile(File file, String encoding) throws ParseException, FileNotFoundException {
        String longName;
        if (encoding == null) {
            encoding = this.encoding;
        }
        String string = longName = this.context == null ? file.getAbsolutePath() : this.context.getRealPath(file.toString());
        if (longName == null) {
            throw new FileNotFoundException(file.toString());
        }
        int fileid = this.registerSourceFile(longName);
        if (fileid == -1) {
            throw new ParseException(Constants.getString("jsp.error.file.already.registered", new Object[]{file}));
        }
        this.currFileId = fileid;
        InputStreamReader reader = null;
        try {
            try {
                if (this.context == null) {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                } else {
                    String fileName = this.context.getRealPath(file.toString());
                    InputStream in = this.context.getResourceAsStream(file.toString());
                    if (in == null) {
                        throw new FileNotFoundException(fileName);
                    }
                    try {
                        reader = new InputStreamReader(in, encoding);
                    }
                    catch (Throwable ex) {
                        throw new FileNotFoundException(fileName + ": " + ex.getMessage());
                    }
                }
                CharArrayWriter caw = new CharArrayWriter();
                char[] buf = new char[1024];
                int i = 0;
                while ((i = reader.read(buf)) != -1) {
                    caw.write(buf, 0, i);
                }
                caw.close();
                if (this.current == null) {
                    this.current = new Mark(this, caw.toCharArray(), fileid, this.getFile(fileid), this.master, encoding);
                } else {
                    this.current.pushStream(caw.toCharArray(), fileid, this.getFile(fileid), this.master, encoding);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (Throwable ex) {
                this.loghelper.log("Exception parsing file " + file, ex);
                this.popFile();
                throw new ParseException(Constants.getString("jsp.error.file.cannot.read", new Object[]{file}));
            }
            Object var10_12 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception any) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception any) {}
        reader.close();
        return;
    }

    public boolean popFile() throws ParseException {
        if (this.current == null) {
            return false;
        }
        if (this.currFileId < 0) {
            throw new ParseException(Constants.getString("jsp.error.no.more.content"));
        }
        String fName = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(fName);
        if (this.currFileId < -1) {
            throw new ParseException(Constants.getString("jsp.error.file.not.registered", new Object[]{fName}));
        }
        boolean r = this.current.popStream();
        if (r) {
            this.master = this.current.baseDir;
        }
        return r;
    }

    protected JspReader(String file, JspCompilationContext ctx, String encoding) throws ParseException, FileNotFoundException {
        this.context = ctx;
        this.encoding = encoding;
        if (this.encoding == null) {
            this.encoding = "8859_1";
        }
        this.pushFile(file, encoding);
    }

    public static JspReader createJspReader(String file, JspCompilationContext ctx, String encoding) throws ParseException, FileNotFoundException {
        return new JspReader(file, ctx, encoding);
    }

    public boolean hasMoreInput() throws ParseException {
        if (this.current.cursor >= this.current.stream.length) {
            while (this.popFile()) {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int nextChar() throws ParseException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    String nextContent() {
        char ch;
        int cur_cursor = this.current.cursor;
        int len = this.current.stream.length;
        if (this.peekChar() == 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < len && (ch = this.current.stream[this.current.cursor]) != '<') {
            if (ch == '\n') {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
        }
        return new String(this.current.stream, cur_cursor, this.current.cursor - cur_cursor);
    }

    char[] getChars(Mark start, Mark stop) throws ParseException {
        Mark oldstart = this.mark();
        this.reset(start);
        try {
            CharArrayWriter caw = new CharArrayWriter();
            while (!stop.equals(this.mark())) {
                caw.write(this.nextChar());
            }
            caw.close();
            this.reset(oldstart);
            return caw.toCharArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ParseException(ex.toString());
        }
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public boolean matchesIgnoreCase(String string) throws ParseException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if (Character.toLowerCase((char)(ch = this.nextChar())) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) throws ParseException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if ((char)(ch = this.nextChar()) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public void advance(int n) throws ParseException {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() throws ParseException {
        int i = 0;
        while (this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public Mark skipUntil(String limit) throws ParseException {
        Mark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block3: {
                if (ch == limit.charAt(0)) {
                    for (int i = 1; i < limlen; ++i) {
                        if (Character.toLowerCase((char)this.nextChar()) == limit.charAt(i)) continue;
                        this.reset(ret);
                        this.advance(1);
                        break block3;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean quoted) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int ch = this.peekChar();
        if (quoted) {
            if (ch != 34 && ch != 39) throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.quoted"));
            int endQuote = ch == 34 ? 34 : 39;
            ch = this.nextChar();
            ch = this.nextChar();
            while (ch != -1 && ch != endQuote) {
                if (ch == 92) {
                    ch = this.nextChar();
                }
                stringBuffer.append((char)ch);
                ch = this.nextChar();
            }
            if (ch != -1) return stringBuffer.toString();
            throw new ParseException(this.mark(), Constants.getString("jsp.error.quotes.unterminated"));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((ch = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                ch = this.nextChar();
            }
            stringBuffer.append((char)ch);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    private void parseAttributeValue(Hashtable into) throws ParseException {
        this.skipSpaces();
        String name = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.novalue", new Object[]{name}));
        }
        char ch = (char)this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true);
        this.skipSpaces();
        into.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributesBean() throws ParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == 62) {
                return values;
            }
            if (ch == 47) {
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        return hashtable;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributes() throws ParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            int ch;
            block17: {
                Mark mark;
                this.skipSpaces();
                ch = this.peekChar();
                if (ch == 62) {
                    return values;
                }
                if (ch == 45) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 45 && this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 37) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 47) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                    }
                    finally {
                        this.reset(mark);
                    }
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public void parseParamTag(Hashtable into) throws ParseException {
        if (this.matches("param")) {
            this.advance(6);
            this.parseParams(into);
        }
    }

    public void parsePluginParamTag(Hashtable into) throws ParseException {
        if (this.matches("<jsp:param")) {
            this.advance(11);
            this.parseParams(into);
        }
    }

    private void parseParams(Hashtable into) throws ParseException {
        Hashtable attrs = this.parseTagAttributes();
        String name = (String)attrs.get("name");
        String value = (String)attrs.get("value");
        if (name == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.noname"));
        }
        if (value == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.novalue"));
        }
        String[] oldval = (String[])into.get(name);
        if (oldval == null) {
            String[] newval = new String[]{value};
            into.put(name, newval);
        } else {
            String[] newval = new String[oldval.length + 1];
            System.arraycopy(oldval, 0, newval, 0, oldval.length);
            newval[oldval.length] = value;
            into.put(name, newval);
        }
    }

    private boolean isDelimiter() throws ParseException {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == 61 || ch == 62 || ch == 34 || ch == 39 || ch == 47) {
                return true;
            }
            if (ch == 45) {
                Mark mark = this.mark();
                ch = this.nextChar();
                if (ch == 62 || ch == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }
}

