/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ClassName;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.tomcat.util.log.Log;

public class JspCompiler
extends Compiler
implements Mangler {
    String pkgName;
    String javaFileName;
    String classFileName;
    String realClassName;
    File jsp;
    String outputDir;
    boolean outDated;
    static final int JSP_TOKEN_LEN = "_jsp_".length();
    Log loghelper = Log.getLog((String)"JASPER_LOG", (String)"JspCompiler");
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public JspCompiler(JspCompilationContext ctxt) throws JasperException {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
        if (this.isOutDated()) {
            this.generateNewClassName();
        }
    }

    private void generateNewClassName() {
        File classFile = new File(this.getClassFileName());
        if (!classFile.exists()) {
            String prefix = this.getPrefix(this.jsp.getPath());
            this.realClassName = prefix + this.getBaseClassName() + "_jsp_" + "0";
            return;
        }
        String cn = this.getRealClassName();
        String baseClassName = cn.substring(0, cn.lastIndexOf("_jsp_"));
        int jspTokenIdx = cn.lastIndexOf("_jsp_");
        String versionS = cn.substring(jspTokenIdx + JSP_TOKEN_LEN, cn.length());
        int number = Integer.valueOf(versionS);
        this.realClassName = baseClassName + "_jsp_" + ++number;
    }

    public final String getRealClassName() {
        if (this.realClassName != null) {
            return this.realClassName;
        }
        try {
            this.realClassName = ClassName.getClassName(this.getClassFileName());
        }
        catch (JasperException ex) {
            this.loghelper.log("Exception in getRealClassName", (Throwable)((Object)ex));
            return null;
        }
        return this.realClassName;
    }

    public final String getClassName() {
        String cn = this.getRealClassName();
        int lastDot = cn.lastIndexOf(46);
        String className = null;
        className = lastDot != -1 ? cn.substring(lastDot + 1, cn.length()) : cn;
        return className;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = this.getClassName() + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = this.outputDir + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = prefix + this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = this.outputDir + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getPackageName() {
        if (this.pkgName != null) {
            return this.pkgName;
        }
        String pathName = this.jsp.getPath();
        StringBuffer modifiedpkgName = new StringBuffer();
        int indexOfSepChar = pathName.lastIndexOf(File.separatorChar);
        if (indexOfSepChar == -1 || indexOfSepChar == 0) {
            this.pkgName = null;
        } else {
            int i;
            for (i = 0; i < keywords.length; ++i) {
                int index;
                char fs = File.separatorChar;
                int index1 = pathName.indexOf(fs + keywords[i]);
                int index2 = pathName.indexOf(keywords[i]);
                if (index1 == -1 && index2 == -1) continue;
                int n = index = index2 == -1 ? index1 : index2;
                while (index != -1) {
                    String tmpathName = pathName.substring(0, index + 1) + '%';
                    pathName = tmpathName + pathName.substring(index + 2);
                    index = pathName.indexOf(fs + keywords[i]);
                }
            }
            pathName = pathName.replace('.', '_');
            this.pkgName = pathName.substring(0, pathName.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            for (i = 0; i < this.pkgName.length(); ++i) {
                if (Character.isLetter(this.pkgName.charAt(i)) || this.pkgName.charAt(i) == '.') {
                    modifiedpkgName.append(this.pkgName.substring(i, i + 1));
                    continue;
                }
                modifiedpkgName.append(JspCompiler.mangleChar(this.pkgName.charAt(i)));
            }
            if (modifiedpkgName.charAt(0) == '.') {
                String modifiedpkgNameString = modifiedpkgName.toString();
                this.pkgName = modifiedpkgNameString.substring(1, modifiedpkgName.length());
            } else {
                this.pkgName = modifiedpkgName.toString();
            }
        }
        return this.pkgName;
    }

    private final String getBaseClassName() {
        String className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer modifiedClassName = new StringBuffer();
        char c = '/';
        if (Character.isDigit(className.charAt(0))) {
            className = "_" + className;
        }
        for (int i = 0; i < className.length(); ++i) {
            char prev = c;
            c = className.charAt(i);
            if (prev == '/' && c == '/') continue;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '/') {
                modifiedClassName.append(className.substring(i, i + 1));
                continue;
            }
            modifiedClassName.append(JspCompiler.mangleChar(className.charAt(i)));
        }
        return modifiedClassName.toString();
    }

    private final String getPrefix(String pathName) {
        if (pathName != null) {
            StringBuffer modifiedName = new StringBuffer();
            for (int i = 0; i < pathName.length(); ++i) {
                if (Character.isLetter(pathName.charAt(i))) {
                    modifiedName.append(pathName.substring(i, i + 1));
                    continue;
                }
                modifiedName.append(JspCompiler.mangleChar(pathName.charAt(i)));
            }
            return modifiedName.toString();
        }
        return "";
    }

    private static final String mangleChar(char ch) {
        int i;
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        for (i = 1; i <= nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros + 1;
        int j = 0;
        while (i < 6) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return new String(result);
    }

    public boolean isOutDated() {
        File jspReal = null;
        String realPath = this.ctxt.getRealPath(this.jsp.getPath());
        if (realPath == null) {
            return true;
        }
        jspReal = new File(realPath);
        if (!jspReal.exists()) {
            return true;
        }
        File classFile = new File(this.getClassFileName());
        this.outDated = classFile.exists() ? classFile.lastModified() < jspReal.lastModified() : true;
        return this.outDated;
    }
}

