/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Stack;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.ResourceCollection;
import org.apache.tomcat.facade.SCAction;
import org.apache.tomcat.facade.SecurityConstraint;
import org.apache.tomcat.facade.ServletInfo;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebXmlReader
extends BaseInterceptor {
    public static final String[] defaultWelcomeList = new String[]{"index.jsp", "index.html", "index.htm"};
    public static final int DEFAULT_SESSION_TIMEOUT = 30;
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    boolean validate = true;
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public void setValidate(boolean b) {
        this.validate = b;
    }

    private void readDefaultWebXml(Context ctx) throws TomcatException {
        String tchome;
        ContextManager cm = ctx.getContextManager();
        String home = cm.getHome();
        File default_xml = new File(home + "/conf/web.xml");
        if (!default_xml.exists() && (tchome = ctx.getContextManager().getInstallDir()) != null) {
            default_xml = new File(tchome + "/conf/web.xml");
        }
        if (!default_xml.exists()) {
            return;
        }
        this.processWebXmlFile(ctx, default_xml.getPath());
    }

    public void contextInit(Context ctx) throws TomcatException {
        if (this.debug > 0) {
            this.log("contextInit  " + ctx.getPath() + " " + ctx.getDocBase());
        }
        ContextManager cm = ctx.getContextManager();
        try {
            String[] newWF;
            ctx.setSessionTimeOut(30);
            File inf_xml = new File(ctx.getAbsolutePath() + "/WEB-INF/web.xml");
            if (inf_xml.exists()) {
                this.processWebXmlFile(ctx, inf_xml.getPath());
            }
            if ((newWF = ctx.getWelcomeFiles()) == null || newWF.length == 0) {
                for (int i = 0; i < defaultWelcomeList.length; ++i) {
                    ctx.addWelcomeFile(defaultWelcomeList[i]);
                }
            }
        }
        catch (Exception e) {
            String msg = sm.getString("context.getConfig.e", (Object)(ctx.getPath() + " " + ctx.getDocBase()));
            this.log(msg, e);
        }
    }

    void processWebXmlFile(Context ctx, String file) {
        try {
            File f = new File(FileUtil.patch((String)file));
            if (!f.exists()) {
                ctx.log("File not found " + f + ", using only defaults");
                return;
            }
            if (ctx.getDebug() > 0) {
                ctx.log("Reading " + file);
            }
            XmlMapper xh = new XmlMapper();
            WebXmlErrorHandler xeh = null;
            File v = new File(ctx.getWorkDir(), "webxmlval.txt");
            if (this.validate && (!v.exists() || v.lastModified() < f.lastModified())) {
                ctx.log("Validating web.xml");
                xh.setValidating(true);
                xeh = new WebXmlErrorHandler(xh, ctx);
                xh.setErrorHandler((ErrorHandler)xeh);
            }
            xh.registerDTDRes("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "org/apache/tomcat/resources/web.dtd");
            xh.addRule("web-app/context-param", xh.methodSetter("addInitParameter", 2));
            xh.addRule("web-app/context-param/param-name", xh.methodParam(0));
            xh.addRule("web-app/context-param/param-value", xh.methodParam(1));
            xh.addRule("web-app/description", xh.methodSetter("setDescription", 0));
            xh.addRule("web-app/icon/small-icon", xh.methodSetter("setIcon", 0));
            xh.addRule("web-app/distributable", xh.methodSetter("setDistributable", 0));
            xh.addRule("web-app/servlet-mapping", xh.methodSetter("addServletMapping", 2));
            xh.addRule("web-app/servlet-mapping/servlet-name", xh.methodParam(1));
            xh.addRule("web-app/servlet-mapping/url-pattern", xh.methodParam(0));
            xh.addRule("web-app/taglib", xh.methodSetter("addTaglib", 2));
            xh.addRule("web-app/taglib/taglib-uri", xh.methodParam(0));
            xh.addRule("web-app/taglib/taglib-location", xh.methodParam(1));
            xh.addRule("web-app/env-entry", xh.methodSetter("addEnvEntry", 4));
            xh.addRule("web-app/env-entry/env-entry-name", xh.methodParam(0));
            xh.addRule("web-app/env-entry/env-entry-type", xh.methodParam(1));
            xh.addRule("web-app/env-entry/env-entry-value", xh.methodParam(2));
            xh.addRule("web-app/env-entry/description", xh.methodParam(3));
            xh.addRule("web-app/login-config", xh.methodSetter("setLoginConfig", 4));
            xh.addRule("web-app/login-config/auth-method", xh.methodParam(0));
            xh.addRule("web-app/login-config/realm-name", xh.methodParam(1));
            xh.addRule("web-app/login-config/form-login-config/form-login-page", xh.methodParam(2));
            xh.addRule("web-app/login-config/form-login-config/form-error-page", xh.methodParam(3));
            xh.addRule("web-app/mime-mapping", xh.methodSetter("addContentType", 2));
            xh.addRule("web-app/mime-mapping/extension", xh.methodParam(0));
            xh.addRule("web-app/mime-mapping/mime-type", xh.methodParam(1));
            xh.addRule("web-app/welcome-file-list/welcome-file", xh.methodSetter("addWelcomeFile", 0));
            xh.addRule("web-app/error-page", xh.methodSetter("addErrorPage", 2));
            xh.addRule("web-app/error-page/error-code", xh.methodParam(0));
            xh.addRule("web-app/error-page/exception-type", xh.methodParam(0));
            xh.addRule("web-app/error-page/location", xh.methodParam(1));
            xh.addRule("web-app/session-config", xh.methodSetter("setSessionTimeOut", 1, new String[]{"int"}));
            xh.addRule("web-app/session-config/session-timeout", xh.methodParam(0));
            xh.addRule("web-app/servlet", xh.objectCreate("org.apache.tomcat.facade.ServletInfo"));
            xh.addRule("web-app/servlet", xh.setParent("setContext"));
            final WebXmlReader wxr = this;
            xh.addRule("web-app/servlet", new XmlAction(){

                public void end(SaxContext xctx) throws Exception {
                    ServletInfo sw = (ServletInfo)xctx.currentObject();
                    Context cctx = (Context)xctx.previousObject();
                    sw.addServlet(cctx, wxr);
                }
            });
            xh.addRule("web-app/servlet/servlet-name", xh.methodSetter("setServletName", 0));
            xh.addRule("web-app/servlet/servlet-class", xh.methodSetter("setServletClassName", 0));
            xh.addRule("web-app/servlet/jsp-file", xh.methodSetter("setJspFile", 0));
            xh.addRule("web-app/servlet/security-role-ref", xh.methodSetter("addSecurityMapping", 3));
            xh.addRule("web-app/servlet/security-role-ref/role-name", xh.methodParam(0));
            xh.addRule("web-app/servlet/security-role-ref/role-link", xh.methodParam(1));
            xh.addRule("web-app/servlet/security-role-ref/description", xh.methodParam(2));
            xh.addRule("web-app/servlet/init-param", xh.methodSetter("addInitParam", 2));
            xh.addRule("web-app/servlet/init-param/param-name", xh.methodParam(0));
            xh.addRule("web-app/servlet/init-param/param-value", xh.methodParam(1));
            xh.addRule("web-app/servlet/icon/small-icon", xh.methodSetter("setIcon", 0));
            xh.addRule("web-app/servlet/description", xh.methodSetter("setDescription", 0));
            xh.addRule("web-app/servlet/load-on-startup", xh.methodSetter("setLoadOnStartUp", 0));
            this.addSecurity(xh);
            Object ctx1 = null;
            xh.useLocalLoader(false);
            Object pd = ctx.getAttribute("org.apache.tomcat.protection_domain");
            if (pd != null) {
                PriviledgedAction di = new PriviledgedAction(xh, f, ctx);
                try {
                    ctx1 = jdk11Compat.doPrivileged((Action)di, pd);
                }
                catch (TomcatException ex1) {
                    throw ex1;
                }
                catch (Exception ex) {
                    throw new TomcatException((Throwable)ex);
                }
            } else {
                ctx1 = xh.readXml(f, (Object)ctx);
            }
            if (this.validate && xeh != null && xeh.isOk()) {
                try {
                    FileOutputStream fos = new FileOutputStream(v);
                    fos.write(1);
                    fos.close();
                }
                catch (IOException ex) {
                    ctx.log("Error creating validation mark ", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.log("ERROR initializing " + file, ex);
            try {
                ctx.setState(2);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    void addSecurity(XmlMapper xh) {
        xh.addRule("web-app/security-constraint", (XmlAction)new SCAction());
        xh.addRule("web-app/security-constraint/user-data-constraint/transport-guarantee", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                SecurityConstraint rc = (SecurityConstraint)st.peek();
                String body = ctx.getBody().trim();
                rc.setTransport(body);
            }
        });
        xh.addRule("web-app/security-constraint/auth-constraint/role-name", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                SecurityConstraint rc = (SecurityConstraint)st.peek();
                String body = ctx.getBody().trim();
                rc.addRole(body);
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                st.push(new ResourceCollection());
            }

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.pop();
                SecurityConstraint sc = (SecurityConstraint)st.peek();
                st.push(rc);
                sc.addResourceCollection(rc);
            }

            public void cleanup(SaxContext ctx) {
                Stack st = ctx.getObjectStack();
                Object o = st.pop();
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection/url-pattern", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.peek();
                String body = ctx.getBody().trim();
                rc.addUrlPattern(body);
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection/http-method", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.peek();
                String body = ctx.getBody().trim();
                rc.addHttpMethod(body);
            }
        });
    }

    static class PriviledgedAction
    extends Action {
        XmlMapper xh;
        File f;
        Context ctx;

        public PriviledgedAction(XmlMapper xh, File f, Context ctx) {
            this.xh = xh;
            this.ctx = ctx;
            this.f = f;
        }

        public Object run() throws Exception {
            return this.xh.readXml(this.f, (Object)this.ctx);
        }
    }

    static class WebXmlErrorHandler
    implements ErrorHandler {
        Context ctx;
        XmlMapper xm;
        boolean ok = true;

        WebXmlErrorHandler(XmlMapper xm, Context ctx) {
            this.ctx = ctx;
            this.xm = xm;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.ok = false;
            this.ctx.log("web.xml: Warning " + exception);
            this.ctx.log(this.xm.positionToString());
        }

        public void error(SAXParseException exception) throws SAXException {
            this.ok = false;
            this.ctx.log("web.xml: Error " + exception);
            this.ctx.log(this.xm.positionToString());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.ok = false;
            this.ctx.log("web.xml: Fatal error " + exception);
            this.ctx.log(this.xm.positionToString());
            throw new SAXException("Fatal error " + exception);
        }

        public boolean isOk() {
            return this.ok;
        }
    }
}

