/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.tomcat.core.Request;

public final class ServletInputStreamFacade
extends ServletInputStream {
    private int bytesRead = 0;
    private int limit = -1;
    private boolean closed = false;
    private Request reqA;
    private static int dL = 0;

    ServletInputStreamFacade() {
    }

    void prepare() {
        int contentLength = this.reqA.getContentLength();
        if (contentLength != -1) {
            this.limit = contentLength;
        }
        this.bytesRead = 0;
    }

    void setRequest(Request reqA) {
        this.reqA = reqA;
    }

    void recycle() {
        this.limit = -1;
        this.closed = false;
    }

    public int read() throws IOException {
        if (dL > 0) {
            this.debug("read() " + this.limit + " " + this.bytesRead);
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.limit == -1) {
            int rd = this.reqA.doRead();
            if (rd < 0) {
                this.limit = 0;
            } else {
                ++this.bytesRead;
            }
            return rd;
        }
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        ++this.bytesRead;
        int rd = this.reqA.doRead();
        if (rd < 0) {
            this.limit = 0;
        }
        return rd;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numRead;
        if (dL > 0) {
            this.debug("read(" + len + ") " + this.limit + " " + this.bytesRead);
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.limit == -1) {
            int numRead2 = this.reqA.doRead(b, off, len);
            if (numRead2 > 0) {
                this.bytesRead += numRead2;
            }
            if (numRead2 < 0) {
                this.limit = 0;
            }
            return numRead2;
        }
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        if (this.bytesRead + len > this.limit) {
            len = this.limit - this.bytesRead;
        }
        if ((numRead = this.reqA.doRead(b, off, len)) > 0) {
            this.bytesRead += numRead;
        }
        return numRead;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        return super.readLine(b, off, len);
    }

    public void close() {
        this.closed = true;
    }

    private void debug(String s) {
        System.out.println("ServletInputStreamFacade: " + s);
    }
}

