/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.HttpServletRequestFacade;
import org.apache.tomcat.facade.HttpServletResponseFacade;
import org.apache.tomcat.facade.ServletInfo;
import org.apache.tomcat.util.collections.SimplePool;

public final class ServletHandler
extends Handler {
    public static final int STATE_DELAYED_INIT = 2;
    public static final int STATE_READY = 3;
    private ServletInfo sw;
    private String servletClassName;
    private SimplePool stmPool = null;
    private int stmPoolSize = 32;
    private int stmInstances = 0;
    private boolean useStmPool = true;
    protected Class servletClass;
    protected Servlet servlet;
    protected Context context;
    long unavailableTime = -1L;

    public String toString() {
        return "ServletH " + this.name + "(" + this.sw + ")";
    }

    public void setServletInfo(ServletInfo sw) {
        this.sw = sw;
    }

    public void setUseSTMPool(boolean useP) {
        this.useStmPool = useP;
    }

    public void setSTMPoolSize(int size) {
        this.stmPoolSize = size;
    }

    public ServletInfo getServletInfo() {
        if (this.sw == null) {
            this.sw = new ServletInfo(this);
        }
        return this.sw;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setServletClassName(String servletClassName) {
        this.servlet = null;
        this.servletClass = null;
        this.servletClassName = servletClassName;
        if (this.debug > 0 && this.sw != null && this.sw.getJspFile() != null) {
            this.log(this.context, "setServletClassName for " + this.sw.getJspFile() + ": " + servletClassName);
        }
    }

    public String getServletClassName() {
        if (this.servletClassName == null) {
            this.servletClassName = this.name;
        }
        return this.servletClassName;
    }

    public final void destroy() {
        if (this.state != 3) {
            this.errorException = null;
            return;
        }
        this.setState(1);
        try {
            this.doDestroy();
        }
        catch (Exception ex) {
            this.log(this.context, "Error during destroy ", ex);
        }
        this.errorException = null;
    }

    public final synchronized void init() {
        if (this.getState() == 3 || this.getState() == 4) {
            return;
        }
        try {
            this.preInit();
        }
        catch (ClassNotFoundException ex) {
            this.log(this.context, "Class not found: " + this.servletClassName);
            this.setErrorException(ex);
            this.setState(4);
            return;
        }
        catch (Exception ex) {
            this.log(this.context, "Exception in preInit " + ex.getMessage(), ex);
            this.setErrorException(ex);
            this.setState(4);
            return;
        }
        if (this.getState() == 2 || this.getState() == 4) {
            return;
        }
        BaseInterceptor[] cI = this.context.getContainer().getInterceptors();
        for (int i = 0; i < cI.length; ++i) {
            try {
                cI[i].preServletInit(this.context, (Handler)this);
                continue;
            }
            catch (TomcatException ex) {
                this.log(this.context, "preServletInit", ex);
            }
        }
        try {
            this.doInit();
        }
        catch (Exception ex) {
            this.log(this.context, "Exception in init  " + ex.getMessage(), ex);
            this.setErrorException(ex);
            this.state = 4;
        }
        for (int i = 0; i < cI.length; ++i) {
            try {
                cI[i].postServletInit(this.context, (Handler)this);
                continue;
            }
            catch (TomcatException ex) {
                this.log(this.context, "postServletInit", ex);
            }
        }
        if (this.state != 4 && this.getErrorException() == null) {
            this.state = 3;
        }
    }

    private void log(Context ctx, String s) {
        if (ctx == null) {
            this.log(s);
        } else {
            ctx.log(s);
        }
    }

    private void log(Context ctx, String s, Throwable t) {
        if (ctx == null) {
            this.log(s, t);
        } else {
            ctx.log(s, t);
        }
    }

    public void reload() {
        if (this.getState() == 3) {
            try {
                this.destroy();
            }
            catch (Exception ex) {
                this.log(this.context, "Error in destroy ", ex);
            }
        }
        if (this.sw.getServletClassName() != null) {
            this.servlet = null;
            this.servletClass = null;
        }
        this.setState(1);
    }

    public Servlet getServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.servlet != null) {
            return this.servlet;
        }
        if (this.debug > 0) {
            this.log(this.context, "LoadServlet " + this.name + " " + this.sw.getServletName() + " " + this.sw.getServletClassName() + " " + this.servletClass);
        }
        if (this.servletClassName == null) {
            this.servletClassName = this.name;
        }
        if (this.servletClass == null) {
            this.servletClass = this.context.getClassLoader().loadClass(this.servletClassName);
        }
        this.servlet = (Servlet)this.servletClass.newInstance();
        if (this.useStmPool && this.servlet instanceof SingleThreadModel) {
            if (this.stmPool == null) {
                this.stmPool = new SimplePool(this.stmPoolSize);
            }
            this.stmPool.put((Object)this.servlet);
            ++this.stmInstances;
        }
        return this.servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() throws TomcatException {
        ServletHandler servletHandler = this;
        synchronized (servletHandler) {
            try {
                if (this.servlet != null) {
                    BaseInterceptor[] cI = this.context.getContainer().getInterceptors();
                    for (int i = 0; i < cI.length; ++i) {
                        try {
                            cI[i].preServletDestroy(this.context, (Handler)this);
                            continue;
                        }
                        catch (TomcatException ex) {
                            this.log(this.context, "preServletDestroy", ex);
                        }
                    }
                    if (this.useStmPool && this.servlet instanceof SingleThreadModel) {
                        Servlet sl = null;
                        while ((sl = (Servlet)this.stmPool.get()) != null) {
                            sl.destroy();
                        }
                        this.stmInstances = 0;
                    } else {
                        this.servlet.destroy();
                    }
                    for (int i = 0; i < cI.length; ++i) {
                        try {
                            cI[i].postServletDestroy(this.context, (Handler)this);
                            continue;
                        }
                        catch (TomcatException ex) {
                            this.log(this.context, "postServletDestroy", ex);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.log(this.context, "Error in destroy ", ex);
            }
        }
    }

    protected void preInit() throws Exception {
        if (this.debug > 0) {
            this.log(this.context, "preInit " + this.servlet + " " + this.sw.getJspFile() + " " + this.servletClassName);
        }
        if (!this.checkAvailable()) {
            return;
        }
        this.setState(1);
        this.getServlet();
    }

    protected void doInit() throws Exception {
        try {
            this.servlet.init(this.getServletInfo().getServletConfig());
        }
        catch (UnavailableException ex) {
            this.setErrorException((Exception)((Object)ex));
            if (ex.isPermanent()) {
                this.setState(4);
            } else {
                this.setState(2);
                this.setServletUnavailable(ex);
            }
            this.servlet = null;
        }
    }

    public void service(Request req, Response res) throws Exception {
        int status;
        int i;
        BaseInterceptor[] ri = this.context.getContainer().getInterceptors(17);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].preInitCheck(req, (Handler)this);
            if (status == 0) continue;
            if (status >= 300) {
                this.contextM.handleStatus(req, res, status);
            }
            return;
        }
        if (this.state != 3) {
            if (this.state != 4) {
                this.init();
            }
            if (this.state == 4 || this.state == 2) {
                Exception ex = this.getErrorException();
                res.setErrorException(ex);
                res.setErrorURI(null);
                this.handleInitError(req, res, ex);
                return;
            }
        }
        ri = this.context.getContainer().getInterceptors(18);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].postInitCheck(req, (Handler)this);
            if (status == 0) continue;
            this.contextM.handleStatus(req, res, status);
            return;
        }
        super.service(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSTMService(HttpServletRequest reqF, HttpServletResponse resF) throws Exception {
        Servlet sl = null;
        try {
            ServletHandler servletHandler;
            boolean newInstance = false;
            sl = (Servlet)this.stmPool.get();
            if (sl == null) {
                servletHandler = this;
                synchronized (servletHandler) {
                    if (this.stmInstances < this.stmPoolSize) {
                        ++this.stmInstances;
                        newInstance = true;
                    }
                }
                if (newInstance) {
                    sl = (Servlet)this.servletClass.newInstance();
                    sl.init(this.getServletInfo().getServletConfig());
                } else {
                    sl = this.servlet;
                }
            }
            servletHandler = sl;
            synchronized (servletHandler) {
                sl.service((ServletRequest)reqF, (ServletResponse)resF);
            }
            Object var9_8 = null;
            if (sl == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (sl == null) throw throwable;
            this.stmPool.put((Object)sl);
            throw throwable;
        }
        this.stmPool.put((Object)sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(Request req, Response res) throws Exception {
        block21: {
            String jspFile = this.sw.getJspFile();
            if (jspFile != null) {
                if (jspFile.startsWith("/")) {
                    req.setAttribute("javax.servlet.include.request_uri", (Object)(req.getContext().getPath() + jspFile));
                } else {
                    req.setAttribute("javax.servlet.include.request_uri", (Object)(req.getContext().getPath() + "/" + jspFile));
                }
                req.setAttribute("javax.servlet.include.servlet_path", (Object)jspFile);
            }
            if (!this.checkAvailable(req, res)) {
                this.handleServiceError(req, res, res.getErrorException());
                return;
            }
            HttpServletRequest reqF = (HttpServletRequest)req.getFacade();
            HttpServletResponse resF = (HttpServletResponse)res.getFacade();
            if (reqF == null || resF == null || !(reqF instanceof HttpServletRequestFacade)) {
                reqF = new HttpServletRequestFacade(req);
                resF = new HttpServletResponseFacade(res);
                req.setFacade((Object)reqF);
                res.setFacade((Object)resF);
            }
            try {
                if (this.servlet instanceof SingleThreadModel) {
                    if (this.useStmPool) {
                        this.doSTMService(reqF, resF);
                        break block21;
                    }
                    Servlet servlet = this.servlet;
                    synchronized (servlet) {
                        this.servlet.service((ServletRequest)reqF, (ServletResponse)resF);
                        break block21;
                    }
                }
                this.servlet.service((ServletRequest)reqF, (ServletResponse)resF);
            }
            catch (UnavailableException ex) {
                if (res.getErrorException() != ex) {
                    res.setErrorException((Exception)((Object)ex));
                    res.setErrorURI(null);
                    if (ex.isPermanent()) {
                        this.setState(4);
                    }
                    if (null == this.getErrorException()) {
                        ServletHandler servletHandler = this;
                        synchronized (servletHandler) {
                            if (null == this.getErrorException()) {
                                if (this.state == 4) {
                                    this.setErrorException((Exception)((Object)ex));
                                } else {
                                    this.setServletUnavailable(ex);
                                }
                            }
                        }
                    }
                }
                this.handleServiceError(req, res, ex);
                return;
            }
        }
        res.setErrorException(null);
        res.setErrorURI(null);
    }

    private void handleError(Request req, Response res, Throwable t) {
        if (t instanceof UnavailableException) {
            int unavailableTime = -1;
            if (!((UnavailableException)t).isPermanent()) {
                unavailableTime = ((UnavailableException)t).getUnavailableSeconds();
                if (unavailableTime <= 0) {
                    unavailableTime = 1;
                }
                res.setHeader("Retry-After", Integer.toString(unavailableTime));
            }
            String msg = t.getMessage();
            String logMsg = "UnavailableException in: " + req + ", time remaining " + unavailableTime + " seconds : " + msg;
            this.log(this.context, logMsg, t);
            req.setAttribute("javax.servlet.error.message", (Object)msg);
            req.setAttribute("tomcat.servlet.error.service.unavailableTime", (Object)new Integer(unavailableTime));
            this.contextM.handleStatus(req, res, 503);
            return;
        }
        this.contextM.handleError(req, res, t);
    }

    protected void handleInitError(Request req, Response res, Throwable t) {
        if (res.isIncluded()) {
            return;
        }
        if (t instanceof ClassNotFoundException) {
            this.contextM.handleStatus(req, res, 404);
        } else {
            this.handleError(req, res, t);
        }
    }

    protected void handleServiceError(Request req, Response res, Throwable t) throws Exception {
        if (res.isIncluded()) {
            throw (Exception)t;
        }
        this.handleError(req, res, t);
    }

    private void setServletUnavailable(UnavailableException ex) {
        this.unavailableTime = System.currentTimeMillis() + (long)(ex.getUnavailableSeconds() * 1000);
        this.setErrorException((Exception)((Object)ex));
    }

    private boolean checkAvailable() {
        if (this.unavailableTime == -1L) {
            return true;
        }
        if (this.unavailableTime - System.currentTimeMillis() < 0L) {
            this.unavailableTime = -1L;
            this.setErrorException(null);
            this.log(this.context, this.getName() + " unavailable time expired, trying again ");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAvailable(Request req, Response res) {
        if (this.unavailableTime == -1L) {
            return true;
        }
        Exception ex = this.getErrorException();
        long moreTime = this.unavailableTime - System.currentTimeMillis();
        if (moreTime < 0L) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this.unavailableTime != -1L) {
                    this.setErrorException(null);
                    this.unavailableTime = -1L;
                    this.log(this.context, this.getName() + " unavailable time expired, trying again ");
                }
                return true;
            }
        }
        int secs = 1;
        if (moreTime > 0L) {
            secs = (int)((moreTime + 999L) / 1000L);
        }
        res.setErrorException((Exception)((Object)new UnavailableException(ex.getMessage(), secs)));
        res.setErrorURI(null);
        return false;
    }

    public String[] _getDepends() {
        return null;
    }
}

