/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.facade.RequestDispatcherImpl;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;

public final class ServletContextFacade
implements ServletContext {
    private StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    private ContextManager contextM;
    private Context context;
    Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    Object accessControlContext = null;

    ServletContextFacade(ContextManager server, Context context) {
        this.contextM = server;
        this.context = context;
        try {
            this.accessControlContext = this.jdk11Compat.getAccessControlContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    Context getRealContext() {
        return this.context;
    }

    public ServletContext getContext(String path) {
        Context target = this.contextM.getContext(this.context, path);
        return (ServletContext)target.getFacade();
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public String getMimeType(String filename) {
        return this.context.getMimeMap().getContentTypeFor(filename);
    }

    public String getRealPath(String path) {
        return FileUtil.safePath((String)this.context.getAbsolutePath(), (String)path);
    }

    public InputStream getResourceAsStream(String path) {
        InputStream is = null;
        try {
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection con = url.openConnection();
            con.connect();
            is = con.getInputStream();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public URL getResource(String rpath) throws MalformedURLException {
        if (rpath == null) {
            return null;
        }
        String absPath = this.context.getAbsolutePath();
        String realPath = FileUtil.safePath((String)absPath, (String)rpath);
        if (realPath == null) {
            this.log("Unsafe path " + absPath + " " + rpath);
            return null;
        }
        File f = new File(realPath);
        if (!f.exists()) {
            return null;
        }
        try {
            return new URL("file", null, 0, realPath);
        }
        catch (IOException ex) {
            this.log("getting resource " + rpath, ex);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        RequestDispatcherImpl rD = new RequestDispatcherImpl(this.context, this.accessControlContext);
        rD.setPath(path);
        return rD;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Handler wrapper = this.context.getServletByName(name);
        if (wrapper == null) {
            return null;
        }
        RequestDispatcherImpl rD = new RequestDispatcherImpl(this.context, this.accessControlContext);
        rD.setName(name);
        return rD;
    }

    public String getServerInfo() {
        return this.context.getEngineHeader();
    }

    public void log(String msg) {
        this.context.logServlet(msg, null);
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public void log(String msg, Throwable t) {
        this.context.logServlet(msg, t);
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        Vector v = new Vector();
        return v.elements();
    }

    public Enumeration getServletNames() {
        Vector v = new Vector();
        return v.elements();
    }
}

