/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.facade.HttpServletRequestFacade;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.res.StringManager;

final class RequestDispatcherImpl
implements RequestDispatcher {
    static final boolean debug = false;
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    private static final String A_REQUEST_URI = "javax.servlet.include.request_uri";
    private static final String A_CONTEXT_PATH = "javax.servlet.include.context_path";
    private static final String A_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String A_PATH_INFO = "javax.servlet.include.path_info";
    private static final String A_QUERY_STRING = "javax.servlet.include.query_string";
    Context context;
    String path;
    String queryString;
    String name;
    private Object accessControlContext = null;
    Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    RDIAction forwardAction = new RDIAction(this, false);
    RDIAction includeAction = new RDIAction(this, true);

    public RequestDispatcherImpl(Context context, Object acc) {
        this.context = context;
        this.accessControlContext = acc;
    }

    public void setPath(String urlPath) {
        int i = urlPath.indexOf("?");
        if (i < 0) {
            this.path = urlPath;
        } else {
            this.path = urlPath.substring(0, i);
            int len = urlPath.length();
            if (i < len) {
                this.queryString = urlPath.substring(i + 1);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                this.forwardAction.prepare(request, response);
                this.jdk11Compat.doPrivileged((Action)this.forwardAction, this.accessControlContext);
            }
            catch (Exception e) {
                this.wrapException(e, null);
            }
        } else {
            this.doForward(request, response);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                this.includeAction.prepare(request, response);
                this.jdk11Compat.doPrivileged((Action)this.includeAction, this.accessControlContext);
            }
            catch (Exception e) {
                this.wrapException(e, null);
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = realRequest.getResponse();
        if (realResponse.isBufferCommitted()) {
            throw new IllegalStateException(sm.getString("rdi.forward.ise"));
        }
        realResponse.resetBuffer();
        if (this.name != null) {
            this.forwardNamed(request, response);
            return;
        }
        realRequest.setContext(this.context);
        realRequest.requestURI().setString(this.context.getPath() + this.path);
        realRequest.unparsedURI().recycle();
        realRequest.servletPath().recycle();
        realRequest.pathInfo().recycle();
        realRequest.setChild(null);
        if (this.queryString != null) {
            realRequest.parameters().handleQueryParameters();
            String oldQS = realRequest.queryString().toString();
            String newQS = oldQS == null ? this.queryString : this.queryString + "&" + oldQS;
            realRequest.queryString().setString(newQS);
            realRequest.parameters().push();
            Parameters child = realRequest.parameters().getCurrentSet();
            child.processParameters(this.queryString);
        }
        this.context.getContextManager().processRequest(realRequest);
        realRequest.removeAttribute(A_REQUEST_URI);
        realRequest.removeAttribute(A_SERVLET_PATH);
        Handler wr = realRequest.getHandler();
        if (wr != null) {
            try {
                wr.service(realRequest, realResponse);
            }
            catch (Exception ex) {
                realResponse.setErrorException(ex);
            }
        }
        if (realResponse.isExceptionPresent()) {
            if (null == realResponse.getErrorURI()) {
                realResponse.setErrorURI(this.context.getPath() + this.path);
            }
            Exception ex = realResponse.getErrorException();
            this.wrapException(ex, sm.getString("dispatcher.forwardException"));
        }
        realResponse.finish();
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = realRequest.getResponse();
        if (this.name != null) {
            this.includeNamed(request, response);
            return;
        }
        boolean old_included = realResponse.isIncluded();
        if (!old_included) {
            realResponse.setIncluded(true);
        }
        Request subRequest = this.context.getContextManager().createRequest(this.context, this.path);
        subRequest.setParent(realRequest);
        subRequest.getTop();
        subRequest.setResponse(realResponse);
        this.context.getContextManager().processRequest(subRequest);
        Object old_request_uri = this.replaceAttribute(realRequest, A_REQUEST_URI, this.context.getPath() + this.path);
        Object old_context_path = this.replaceAttribute(realRequest, A_CONTEXT_PATH, this.context.getPath());
        Object old_servlet_path = this.replaceAttribute(realRequest, A_SERVLET_PATH, subRequest.servletPath().toString());
        Object old_path_info = this.replaceAttribute(realRequest, A_PATH_INFO, subRequest.pathInfo().toString());
        Object old_query_string = this.replaceAttribute(realRequest, A_QUERY_STRING, this.queryString);
        if (this.queryString != null) {
            realRequest.parameters().push();
            Parameters child = realRequest.parameters().getCurrentSet();
            child.processParameters(this.queryString);
        }
        Request old_child = realRequest.getChild();
        subRequest.setParent(old_child);
        realRequest.setChild(subRequest);
        Handler wr = subRequest.getHandler();
        if (wr != null) {
            try {
                wr.service(realRequest, realResponse);
            }
            catch (Exception ex) {
                realResponse.setErrorException(ex);
            }
        }
        realRequest.setChild(old_child);
        if (this.queryString != null) {
            realRequest.parameters().pop();
        }
        this.replaceAttribute(realRequest, A_REQUEST_URI, old_request_uri);
        this.replaceAttribute(realRequest, A_CONTEXT_PATH, old_context_path);
        this.replaceAttribute(realRequest, A_SERVLET_PATH, old_servlet_path);
        this.replaceAttribute(realRequest, A_PATH_INFO, old_path_info);
        this.replaceAttribute(realRequest, A_QUERY_STRING, old_query_string);
        if (!old_included) {
            realResponse.setIncluded(false);
        }
        if (realResponse.isExceptionPresent()) {
            if (null == realResponse.getErrorURI()) {
                realResponse.setErrorURI(this.context.getPath() + this.path);
            }
            Exception ex = realResponse.getErrorException();
            this.wrapException(ex, sm.getString("dispatcher.includeException"));
        }
    }

    private void includeNamed(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Handler wr = this.context.getServletByName(this.name);
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = realRequest.getResponse();
        boolean old_included = realResponse.isIncluded();
        if (!old_included) {
            realResponse.setIncluded(true);
        }
        if (wr != null) {
            try {
                wr.service(realRequest, realResponse);
            }
            catch (Exception ex) {
                realResponse.setErrorException(ex);
            }
        }
        if (!old_included) {
            realResponse.setIncluded(false);
        }
        if (realResponse.isExceptionPresent()) {
            if (null == realResponse.getErrorURI()) {
                realResponse.setErrorURI("named servlet: " + this.name);
            }
            this.wrapException(realResponse.getErrorException(), sm.getString("dispatcher.includeException"));
        }
    }

    private void forwardNamed(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Handler wr = this.context.getServletByName(this.name);
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = realRequest.getResponse();
        if (wr != null) {
            try {
                wr.service(realRequest, realResponse);
            }
            catch (Exception ex) {
                this.wrapException(ex, null);
            }
        }
        if (realResponse.isExceptionPresent()) {
            if (null == realResponse.getErrorURI()) {
                realResponse.setErrorURI("named servlet: " + this.name);
            }
            this.wrapException(realResponse.getErrorException(), sm.getString("dispatcher.forwardException"));
        }
    }

    private Object replaceAttribute(Request realRequest, String name, Object value) {
        Object oldAttribute = realRequest.getAttribute(name);
        if (value == null) {
            realRequest.removeAttribute(name);
        } else {
            realRequest.setAttribute(name, value);
        }
        return oldAttribute;
    }

    private void wrapException(Exception ex, String msg) throws IOException, ServletException, RuntimeException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof ServletException) {
            throw (ServletException)ex;
        }
        if (msg == null) {
            throw new ServletException((Throwable)ex);
        }
        throw new ServletException(msg, (Throwable)ex);
    }

    static class RDIAction
    extends Action {
        ServletRequest req;
        ServletResponse res;
        RequestDispatcherImpl rdi;
        boolean include;

        RDIAction(RequestDispatcherImpl rdi, boolean incl) {
            this.rdi = rdi;
            this.include = incl;
        }

        public void prepare(ServletRequest req, ServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public Object run() throws Exception {
            if (this.include) {
                this.rdi.doInclude(this.req, this.res);
            } else {
                this.rdi.doForward(this.req, this.res);
            }
            return null;
        }
    }
}

