/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.facade.ServletHandler;
import org.apache.tomcat.util.res.StringManager;

public class LoadOnStartupInterceptor
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");

    public void contextInit(Context ctx) {
        Hashtable loadableServlets = new Hashtable();
        this.init(ctx, loadableServlets);
        Vector<Integer> orderedKeys = new Vector<Integer>();
        Enumeration e = loadableServlets.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            int slot = -1;
            for (int i = 0; i < orderedKeys.size(); ++i) {
                if (key >= (Integer)orderedKeys.elementAt(i)) continue;
                slot = i;
                break;
            }
            if (slot > -1) {
                orderedKeys.insertElementAt(key, slot);
                continue;
            }
            orderedKeys.addElement(key);
        }
        for (int i = 0; i < orderedKeys.size(); ++i) {
            Integer key = (Integer)orderedKeys.elementAt(i);
            Enumeration sOnLevel = ((Vector)loadableServlets.get(key)).elements();
            while (sOnLevel.hasMoreElements()) {
                String servletName = (String)sOnLevel.nextElement();
                Handler result = ctx.getServletByName(servletName);
                if (ctx.getDebug() > 0) {
                    ctx.log("Loading " + key + " " + servletName);
                }
                if (result == null) {
                    this.log("Warning: we try to load an undefined servlet " + servletName, 2);
                    continue;
                }
                try {
                    if (result instanceof ServletHandler && ((ServletHandler)result).getServletInfo().getJspFile() != null) {
                        this.loadJsp(ctx, result);
                    }
                    ((ServletHandler)result).init();
                }
                catch (Throwable ee) {
                    String msg = sm.getString("context.loadServlet.e", (Object)servletName);
                    this.log(msg, ee);
                }
            }
        }
    }

    void loadJsp(Context context, Handler result) throws Exception {
        int status;
        int i;
        String path = ((ServletHandler)result).getServletInfo().getJspFile();
        String requestURI = path + "?jsp_precompile=true";
        Request req = this.cm.createRequest(context, requestURI);
        BaseInterceptor[] ri = context.getContainer().getInterceptors(17);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].preInitCheck(req, result);
            if (status == 0) continue;
            return;
        }
        ri = context.getContainer().getInterceptors(18);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].postInitCheck(req, result);
            if (status == 0) continue;
            return;
        }
    }

    void init(Context ctx, Hashtable loadableServlets) {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            ServletHandler sw;
            String name = (String)enumeration.nextElement();
            Handler h = ctx.getServletByName(name);
            if (!(h instanceof ServletHandler) || !(sw = (ServletHandler)h).getServletInfo().getLoadingOnStartUp()) continue;
            Integer level = new Integer(sw.getServletInfo().getLoadOnStartUp());
            Vector v = loadableServlets.get(level) != null ? (Vector)loadableServlets.get(level) : new Vector();
            v.addElement(name);
            loadableServlets.put(level, v);
        }
    }
}

