/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.JasperLiaison;
import org.apache.tomcat.facade.ServletHandler;
import org.apache.tomcat.util.depend.Dependency;

public class JspInterceptor
extends BaseInterceptor {
    static final String JIKES = "org.apache.jasper.compiler.JikesJavaCompiler";
    static final String JSP_SERVLET = "org.apache.jasper.servlet.JspServlet";
    Properties args = new Properties();
    boolean useJspServlet = false;
    boolean useWebAppCL = false;
    String jspServletCN = "org.apache.jasper.servlet.JspServlet";
    String runtimePackage;
    int pageContextPoolSize = 100;
    private static final String SERVLET_NAME_PREFIX = "TOMCAT/JSP";

    public void setKeepGenerated(String s) {
        this.args.put("keepgenerated", s);
    }

    public void setLargeFile(String s) {
        this.args.put("largefile", s);
    }

    public void setMappedFile(String s) {
        this.args.put("mappedfile", s);
    }

    public void setSendErrToClient(String s) {
        this.args.put("sendErrToClient", s);
    }

    public void setIEClassId(String s) {
        this.args.put("ieClassId", s);
    }

    public void setClassPath(String s) {
        this.args.put("classpath", s);
    }

    public void setScratchdir(String s) {
        this.args.put("scratchdir", s);
    }

    public void setJspCompilerPath(String s) {
        this.args.put("jspCompilerPath", s);
    }

    public void setJspCompilerPlugin(String s) {
        this.args.put("jspCompilerPlugin", s);
    }

    public void setClassDebugInfo(String s) {
        this.args.put("classDebugInfo", s);
    }

    public void setProperty(String n, String v) {
        this.args.put(n, v);
    }

    public void setJikesClasspath(String cp) {
        if (cp != null) {
            System.getProperties().put("jikes.class.path", cp);
            if (this.debug > 0) {
                this.log("Setting jikes.class.path to " + cp);
            }
        }
    }

    public void setUseJspServlet(boolean b) {
        this.useJspServlet = b;
    }

    public void setJspServlet(String s) {
        this.jspServletCN = s;
    }

    public void setJavaCompiler(String type) {
        if ("jikes".equals(type)) {
            type = JIKES;
        }
        if ("javac".equals(type)) {
            type = "org.apache.jasper.compiler.SunJavaCompiler";
        }
        this.args.put("jspCompilerPlugin", type);
    }

    public void setPageContextPoolSize(int i) {
        this.pageContextPoolSize = i;
    }

    public void setRuntimePackage(String rp) {
        this.runtimePackage = rp;
    }

    public void setUseWebAppCL(boolean b) {
        this.useWebAppCL = b;
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        if (this.runtimePackage != null) {
            Constants.JSP_RUNTIME_PACKAGE = this.runtimePackage;
            Constants.JSP_SERVLET_BASE = this.runtimePackage + ".HttpJspBase";
        }
        JspFactoryImpl factory = new JspFactoryImpl(this.pageContextPoolSize);
        JspFactory.setDefaultFactory((JspFactory)factory);
        if (!this.useJspServlet) {
            try {
                URL url = new URL("file", null, ctx.getWorkDir().getAbsolutePath().replace('\\', '/') + "/");
                ctx.addClassPath(url);
                if (this.debug > 9) {
                    this.log("Added to classpath: " + url);
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if (this.useJspServlet && !ctx.isTrusted() || this.useWebAppCL) {
            try {
                File f = new File(cm.getInstallDir(), "lib/container/jasper.jar");
                URL url = new URL("file", null, f.getAbsolutePath().replace('\\', '/'));
                ctx.addClassPath(url);
                if (this.debug > 9) {
                    this.log("Added to classpath: " + url);
                }
                if (!(f = new File(System.getProperty("java.home") + "/../lib/tools.jar")).exists()) {
                    f = new File(System.getProperty("java.home") + "/lib/tools.jar");
                    if (!f.exists()) {
                        this.log("Tools.jar not found " + System.getProperty("java.home"));
                    } else {
                        this.log("Detected wrong java.home value " + System.getProperty("java.home"));
                    }
                }
                url = new URL("file", "", f.getAbsolutePath());
                ctx.addClassPath(url);
                if (this.debug > 9) {
                    this.log("Added to classpath: " + url);
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        block12: {
            if (ctx.getContainer("*.jsp") == null) {
                ctx.addServletMapping("*.jsp", "jsp");
            }
            if (this.useJspServlet) {
                ServletHandler jspServlet;
                Handler jasper = ctx.getServletByName("jsp");
                if (this.debug > 10) {
                    this.log("Got jasper servlet " + jasper);
                }
                if ((jspServlet = (ServletHandler)jasper).getServletClassName() == null) {
                    this.log("Jsp already defined in web.xml " + jspServlet.getServletClassName());
                    return;
                }
                if (this.debug > -1) {
                    this.log("jspServlet=" + jspServlet.getServletClassName());
                }
                Enumeration<Object> enumeration = this.args.keys();
                while (enumeration.hasMoreElements()) {
                    String s = (String)enumeration.nextElement();
                    String v = (String)this.args.get(s);
                    if (this.debug > 0) {
                        this.log("Setting " + s + "=" + v);
                    }
                    jspServlet.getServletInfo().addInitParam(s, v);
                }
                if (this.debug > 0) {
                    this.log("Seetting debug on jsp servlet");
                    Constants.jasperLog = this.loghelper;
                }
                jspServlet.setServletClassName(this.jspServletCN);
            }
            if (this.useWebAppCL) {
                try {
                    ctx.getClassLoader().loadClass("sun.tools.javac.Main");
                    if (this.debug > 0) {
                        this.log("Found javac in context init");
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (this.debug <= 0) break block12;
                    this.log("javac not found in context init");
                }
            }
        }
    }

    public void preServletInit(Context ctx, Handler sw) throws TomcatException {
        if (!(sw instanceof ServletHandler)) {
            return;
        }
        try {
            Servlet theServlet = ((ServletHandler)sw).getServlet();
            if (theServlet instanceof HttpJspBase) {
                if (this.debug > 9) {
                    this.log("PreServletInit: HttpJspBase.setParentClassLoader" + sw);
                }
                HttpJspBase h = (HttpJspBase)theServlet;
                h.setClassLoader(ctx.getClassLoader());
            }
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    public int requestMap(Request req) {
        if (this.useJspServlet) {
            return 0;
        }
        Handler wrapper = req.getHandler();
        if (wrapper == null) {
            return 0;
        }
        if (!"jsp".equals(wrapper.getName()) && !(wrapper instanceof ServletHandler)) {
            return 0;
        }
        ServletHandler handler = null;
        String jspFile = null;
        if ("jsp".equals(wrapper.getName())) {
            jspFile = req.servletPath().toString();
            handler = this.mapJspPage(req.getContext(), jspFile);
            req.setHandler((Handler)handler);
        } else if (wrapper instanceof ServletHandler && (jspFile = (handler = (ServletHandler)wrapper).getServletInfo().getJspFile()) == null) {
            return 0;
        }
        return 0;
    }

    public int preInitCheck(Request req, Handler sw) throws TomcatException {
        Dependency dep;
        int i;
        if (sw == null || !(sw instanceof ServletHandler)) {
            return 0;
        }
        ServletHandler handler = (ServletHandler)sw;
        String jspFile = handler.getServletInfo().getJspFile();
        if (jspFile == null) {
            return 0;
        }
        String qString = req.queryString().toString();
        boolean pre_compile = false;
        boolean do_compile = true;
        int n = i = qString == null ? -1 : qString.indexOf("jsp_precompile");
        if (i >= 0) {
            pre_compile = true;
            req.parameters().handleQueryParameters();
            String p = req.parameters().getParameter("jsp_precompile");
            if ("false".equalsIgnoreCase(p)) {
                do_compile = false;
            } else if (p != null && !p.equalsIgnoreCase("true")) {
                req.setAttribute("javax.servlet.error.message", (Object)"Invalid value to jsp_precompile");
                return 500;
            }
        }
        if (((dep = handler.getServletInfo().getDependency()) == null || dep.isExpired()) && do_compile) {
            JasperLiaison liasion = new JasperLiaison(this.getLog(), this.debug, this.useWebAppCL);
            liasion.processJspFile(req, jspFile, handler, this.args);
        }
        if (pre_compile) {
            this.doPreCompileService(req);
            return 200;
        }
        return 0;
    }

    private ServletHandler mapJspPage(Context ctx, String uri) {
        Handler h;
        String servletName = SERVLET_NAME_PREFIX + uri;
        if (this.debug > 0) {
            this.log("mapJspPage " + ctx + " " + " " + servletName + " " + uri);
        }
        if ((h = ctx.getServletByName(servletName)) != null) {
            this.log("Name already exists " + servletName + " while mapping " + uri);
            return (ServletHandler)h;
        }
        ServletHandler wrapper = new ServletHandler();
        wrapper.setModule(this);
        wrapper.setContext(ctx);
        wrapper.setName(servletName);
        wrapper.getServletInfo().setJspFile(uri);
        try {
            ctx.addServlet((Handler)wrapper);
            ctx.addServletMapping(uri, servletName);
            if (this.debug > 0) {
                this.log("Added mapping " + uri + " path=" + servletName);
            }
        }
        catch (TomcatException ex) {
            this.log("mapJspPage: ctx=" + ctx + ", servletName=" + servletName, ex);
            return null;
        }
        return wrapper;
    }

    private void doPreCompileService(Request req) {
        Response res = req.getResponse();
        if (res == null || res.getBuffer() == null) {
            return;
        }
        try {
            res.setContentType("text/html");
            String msg = "<h1>Jsp Precompile Done</h1>";
            res.setContentLength(msg.length());
            res.getBuffer().write(msg);
        }
        catch (IOException iex) {
            this.log("Pre-compile error", iex);
        }
    }
}

