/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperEngineContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperOptionsImpl;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JasperMangler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JikesJavaCompiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.ServletHandler;
import org.apache.tomcat.facade.ServletInfo;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;
import org.apache.tomcat.util.log.Log;

final class JasperLiaison {
    Log log;
    final int debug;
    boolean useWebAppCL;
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    String javaEncoding = "UTF8";
    static String sep = System.getProperty("path.separator");
    static boolean tryJikes = false;
    static Class jspCompilerPlugin = null;

    JasperLiaison(Log log, int debug, boolean useWebAppCL) {
        this.log = log;
        this.debug = debug;
        this.useWebAppCL = useWebAppCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int processJspFile(Request req, String jspFile, ServletHandler handler, Properties args) {
        if (this.debug > 10) {
            this.log.log("Before compile sync  " + jspFile);
        }
        ServletHandler servletHandler = handler;
        synchronized (servletHandler) {
            ClassLoader savedContextCL;
            JasperMangler mangler;
            Context ctx;
            Dependency dep;
            block25: {
                dep = handler.getServletInfo().getDependency();
                if (dep != null && !dep.isExpired()) {
                    return 0;
                }
                ctx = req.getContext();
                mangler = new JasperMangler(ctx.getWorkDir().getAbsolutePath(), ctx.getAbsolutePath(), jspFile);
                String path = mangler.getJspFilePath();
                if (path == null) {
                    return 404;
                }
                File f = new File(path);
                if (!f.exists()) {
                    return 404;
                }
                if (dep == null) {
                    dep = this.setDependency(ctx, mangler, handler);
                    if (dep == null) {
                        return 404;
                    }
                    handler.setServletClassName(mangler.getServletClassName());
                    if (!dep.isExpired()) {
                        return 0;
                    }
                }
                ctx.log("Compiling: " + jspFile + " to " + mangler.getServletClassName());
                handler.setErrorException(null);
                handler.setState(1);
                mangler.nextVersion();
                dep.setLastModified(System.currentTimeMillis());
                if (this.debug > 1) {
                    this.log.log("Update class Name " + mangler.getServletClassName());
                }
                handler.setServletClassName(mangler.getServletClassName());
                savedContextCL = this.containerCCL(ctx.getContextManager().getContainerLoader());
                if (this.useWebAppCL) {
                    block24: {
                        try {
                            ctx.getClassLoader().loadClass("sun.tools.javac.Main");
                            if (this.debug > 0) {
                                this.log.log("Found javac using context loader");
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            if (this.debug <= 0) break block24;
                            this.log.log("javac not found using context loader");
                        }
                    }
                    try {
                        ctx.getContextManager().getContainerLoader().loadClass("sun.tools.javac.Main");
                        if (this.debug > 0) {
                            this.log.log("Found javac using container loader");
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        if (this.debug <= 0) break block25;
                        this.log.log("javac not found using container loader");
                    }
                }
            }
            try {
                JasperOptionsImpl options = new JasperOptionsImpl(args);
                JspCompilationContext ctxt = this.createCompilationContext(req, jspFile, (Options)options, (Mangler)mangler);
                this.jsp2java(mangler, ctxt);
                this.javac(req, (Options)options, ctxt, (Mangler)mangler);
                if (this.debug > 0) {
                    this.log.log("Generated " + mangler.getClassFileName());
                }
            }
            catch (FileNotFoundException fnfex) {
                this.containerCCL(savedContextCL);
                return 404;
            }
            catch (Exception ex) {
                if (ctx != null) {
                    ctx.log("compile error: req=" + req, (Throwable)ex);
                } else {
                    this.log.log("compile error: req=" + req, (Throwable)ex);
                }
                handler.setErrorException(ex);
                handler.setState(4);
                this.containerCCL(savedContextCL);
                return 500;
            }
            this.containerCCL(savedContextCL);
            dep.setExpired(false);
        }
        return 0;
    }

    ClassLoader containerCCL(ClassLoader cl) {
        ClassLoader orig = jdk11Compat.getContextClassLoader();
        jdk11Compat.setContextClassLoader(cl);
        return orig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jsp2java(JasperMangler mangler, JspCompilationContext ctxt) throws Exception {
        if (this.debug > 0) {
            this.log.log("Generating " + mangler.getJavaFileName());
        }
        String javaFileName = mangler.getJavaFileName();
        File javaFile = new File(javaFileName);
        new File(javaFile.getParent()).mkdirs();
        Compiler compiler = new Compiler(ctxt);
        compiler.setMangler((Mangler)mangler);
        compiler.setJavaCompiler(null);
        JasperMangler jasperMangler = mangler;
        synchronized (jasperMangler) {
            compiler.compile();
        }
        if (this.debug > 0) {
            File f = new File(mangler.getJavaFileName());
            this.log.log("Created file : " + f + " " + f.lastModified());
        }
    }

    private void prepareCompiler(Request req, JavaCompiler javac, Options options, JspCompilationContext ctxt) throws JasperException {
        String compilerPath = options.getJspCompilerPath();
        if (compilerPath != null) {
            javac.setCompilerPath(compilerPath);
        }
        javac.setClassDebugInfo(options.getClassDebugInfo());
        javac.setEncoding(this.javaEncoding);
        String cp = "";
        if (javac instanceof JikesJavaCompiler) {
            String jikesCP;
            if (!System.getProperty("java.version").startsWith("1.1")) {
                cp = System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar" + sep;
            }
            if ((jikesCP = System.getProperty("jikes.class.path")) != null && jikesCP.length() > 0) {
                cp = cp + jikesCP + sep;
            }
        }
        cp = cp + System.getProperty("java.class.path") + sep + ctxt.getClassPath() + sep + ctxt.getOutputDir();
        javac.setClasspath(cp);
        javac.setOutputDir(ctxt.getOutputDir());
        if (javac instanceof SunJavaCompiler && this.useWebAppCL) {
            ClassLoader cl = req.getContext().getClassLoader();
            ((SunJavaCompiler)javac).setLoader(cl);
        }
        if (this.debug > 5) {
            this.log.log("ClassPath " + cp);
        }
    }

    void javac(Request req, Options options, JspCompilationContext ctxt, Mangler mangler) throws JasperException {
        String javaFileName = mangler.getJavaFileName();
        if (this.debug > 0) {
            this.log.log("Compiling java file " + javaFileName);
        }
        boolean status = true;
        if (jspCompilerPlugin == null) {
            jspCompilerPlugin = options.getJspCompilerPlugin();
        }
        if (jspCompilerPlugin == null && tryJikes) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            try {
                jspCompilerPlugin = Class.forName("org.apache.jasper.compiler.JikesJavaCompiler");
                JavaCompiler javaC = this.createJavaCompiler(jspCompilerPlugin);
                this.prepareCompiler(req, javaC, options, ctxt);
                javaC.setMsgOutput((OutputStream)out);
                status = javaC.compile(javaFileName);
            }
            catch (Exception ex) {
                this.log.log("Guess java compiler: no jikes " + ex.toString());
                status = false;
            }
            if (!status) {
                this.log.log("Guess java compiler: no jikes ");
                this.log.log("Guess java compiler: OUT " + out.toString());
                jspCompilerPlugin = null;
                tryJikes = false;
            } else {
                this.log.log("Guess java compiler: using jikes ");
            }
        }
        JavaCompiler javaC = this.createJavaCompiler(jspCompilerPlugin);
        this.prepareCompiler(req, javaC, options, ctxt);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        javaC.setMsgOutput((OutputStream)out);
        status = javaC.compile(javaFileName);
        if (!ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException("Unable to compile " + msg);
        }
        if (this.debug > 0) {
            this.log.log("Compiled ok");
        }
    }

    public JavaCompiler createJavaCompiler(Class jspCompilerPlugin) throws JasperException {
        SunJavaCompiler javac;
        if (jspCompilerPlugin != null) {
            try {
                javac = (JavaCompiler)jspCompilerPlugin.newInstance();
            }
            catch (Exception ex) {
                Constants.message((String)"jsp.warning.compiler.class.cantcreate", (Object[])new Object[]{jspCompilerPlugin, ex}, (int)Integer.MIN_VALUE);
                javac = new SunJavaCompiler();
            }
        } else {
            javac = new SunJavaCompiler();
        }
        return javac;
    }

    private String computeClassPath(Context ctx) {
        URL[] commonCP;
        URL[] appsCP;
        String separator = System.getProperty("path.separator", ":");
        URL[] classP = ctx.getClassPath();
        String cpath = "";
        cpath = cpath + this.extractClassPath(classP);
        Jdk11Compat jdkProxy = Jdk11Compat.getJdkCompat();
        ClassLoader loader = ctx.getClassLoader();
        if (jdkProxy.isJava2()) {
            appsCP = jdkProxy.getURLs(loader, 2);
            commonCP = jdkProxy.getURLs(loader, 3);
        } else {
            appsCP = jdkProxy.getURLs(loader, 1);
            commonCP = jdkProxy.getURLs(loader, 2);
        }
        if (appsCP != null) {
            cpath = cpath + separator + this.extractClassPath(appsCP);
        }
        if (commonCP != null) {
            cpath = cpath + separator + this.extractClassPath(commonCP);
        }
        return cpath;
    }

    String extractClassPath(URL[] urls) {
        String separator = System.getProperty("path.separator", ":");
        String cpath = "";
        for (int i = 0; i < urls.length; ++i) {
            URL cp = urls[i];
            if (cp == null) continue;
            File f = new File(cp.getFile());
            if (cpath.length() > 0) {
                cpath = cpath + separator;
            }
            cpath = cpath + f;
        }
        return cpath;
    }

    private JspCompilationContext createCompilationContext(Request req, String jspFile, Options opt, Mangler mangler) {
        JasperEngineContext ctxt = new JasperEngineContext();
        ctxt.setServletClassName(mangler.getClassName());
        ctxt.setJspFile(jspFile);
        ctxt.setClassPath(this.computeClassPath(req.getContext()));
        ctxt.setServletContext(req.getContext().getFacade());
        ctxt.setOptions(opt);
        ctxt.setClassLoader(req.getContext().getClassLoader());
        ctxt.setOutputDir(req.getContext().getWorkDir().getAbsolutePath());
        return ctxt;
    }

    private Dependency setDependency(Context ctx, JasperMangler mangler, ServletHandler handler) {
        ServletInfo info = handler.getServletInfo();
        if (this.debug > 0) {
            this.log.log("Registering dependency for " + (Object)((Object)handler));
        }
        Dependency dep = new Dependency();
        String jspFilePath = mangler.getJspFilePath();
        if (jspFilePath == null) {
            return null;
        }
        dep.setOrigin(new File(jspFilePath));
        dep.setTarget((Object)handler);
        dep.setLocal(true);
        File f = new File(mangler.getClassFileName());
        if (mangler.getVersion() > 0) {
            dep.setLastModified(f.lastModified());
            dep.checkExpiry();
        } else {
            dep.setLastModified(-1L);
            dep.setExpired(true);
        }
        if (this.debug > 0) {
            this.log.log("file = " + mangler.getClassFileName() + " " + f.lastModified());
        }
        if (this.debug > 0) {
            this.log.log("origin = " + dep.getOrigin() + " " + dep.getOrigin().lastModified());
        }
        try {
            DependManager dm = (DependManager)ctx.getContainer().getNote("DependManager");
            if (dm != null) {
                dm.addDependency(dep);
            }
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
        info.setDependency(dep);
        return dep;
    }
}

