/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.facade.SessionContextImpl;
import org.apache.tomcat.util.res.StringManager;

public final class HttpSessionFacade
implements HttpSession {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    ServerSession realSession;
    private String sessionId;
    private boolean isValid = false;
    private static final int dL = 0;

    HttpSessionFacade() {
    }

    void setRealSession(ServerSession s) {
        this.realSession = s;
        this.realSession.setFacade((Object)this);
        this.sessionId = this.realSession.getId().toString();
        this.isValid = true;
    }

    void recycle() {
        this.isValid = false;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getCreationTime() {
        this.checkValid();
        return this.realSession.getTimeStamp().getCreationTime();
    }

    public HttpSessionContext getSessionContext() {
        return new SessionContextImpl();
    }

    public long getLastAccessedTime() {
        return this.realSession.getTimeStamp().getLastAccessedTime();
    }

    public void invalidate() {
        this.checkValid();
        this.realSession.getTimeStamp().setValid(false);
        this.realSession.setState(2);
        this.realSession.recycle();
        this.realSession.setState(3);
    }

    public boolean isNew() {
        this.checkValid();
        return this.realSession.getTimeStamp().isNew();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        this.checkValid();
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionFacade httpSessionFacade = this;
            synchronized (httpSessionFacade) {
                Object oldValue = this.realSession.getAttribute(name);
                if (oldValue != null) {
                    this.removeAttribute(name);
                }
                try {
                    ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
                }
                catch (Throwable th) {
                    // empty catch block
                }
                this.realSession.setAttribute(name, value);
            }
        }
        Object oldValue = this.realSession.getAttribute(name);
        if (oldValue != null) {
            this.removeAttribute(name);
        }
        this.realSession.setAttribute(name, value);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Object getAttribute(String name) {
        this.checkValid();
        return this.realSession.getAttribute(name);
    }

    public String[] getValueNames() {
        this.checkValid();
        Enumeration attrs = this.getAttributeNames();
        String[] names = new String[this.realSession.getAttributeCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)attrs.nextElement();
        }
        return names;
    }

    public Enumeration getAttributeNames() {
        this.checkValid();
        return this.realSession.getAttributeNames();
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        this.checkValid();
        Object object = this.realSession.getAttribute(name);
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionFacade httpSessionFacade = this;
            synchronized (httpSessionFacade) {
                object = this.realSession.getAttribute(name);
                if (object != null) {
                    this.realSession.removeAttribute(name);
                    try {
                        ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
            }
        }
        this.realSession.removeAttribute(name);
    }

    public void setMaxInactiveInterval(int interval) {
        this.realSession.getTimeStamp().setMaxInactiveInterval((long)(interval * 1000));
    }

    public int getMaxInactiveInterval() {
        return (int)this.realSession.getTimeStamp().getMaxInactiveInterval() / 1000;
    }

    private void checkValid() {
        if (!this.realSession.getTimeStamp().isValid() || !this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
    }

    private void d(String s) {
        System.err.println("HttpSessionFacade: " + s);
    }
}

